package gov.va.caret.util;

import java.net.URI;
import java.net.URL;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.beanutils.Converter;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.dashboard.config.FacilityDashboardConfig;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Facil;
import gov.va.caret.model.Note;
import gov.va.caret.model.Persn;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.impl.NoteImpl;
import gov.va.caret.model.impl.WorImImpl;
import gov.va.caret.model.support.NoteSupport;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.view.CaretParam;



public class Toolbox {

	private static Map<String,Map<String,Map<String,Long>>> districtMap = null;
	
	static final String CARET_DATE_FORMAT = "MM/dd/yy";
	static final String CARET_DATE_ORIENT = "yyyyMMdd";
	static final String CARET_DATE_FORMAT_PDF = "MM-dd-yyyy";
	static final String CARET_DATE_FORMAT_CPRS = "MM/dd/yyyy";
	static final String CARET_DATE_FORMAT_UI = "MM/DD/YYYY";
	static final String CARET_DATETIME_FORMAT = "MM/dd/yy hh:mm a";
	static final String CARET_DATETIME_METADATA_FORMAT = "MM/dd/yyyy hh:mm:ss a z";
	static final String CARET_DATETIME_FORMAT_EXPANDED = "EEE MMM dd HH:mm:ss z yyyy";

	private static Format currencyInstance = null;
	private static Format dateFormat = null;
	private static Format dateFormatPdf = null;
	private static Format dateFormatCprs = null;
	private static Format dateTimeFormat = null;
	private static Format dateMetadata = null;
	private static Format dateFormatOrient = null;
	private static Format dateTimeFormatExpanded = null;
	
	public static final String FOUR = "0000";
	public static final String THREE = "000";
	private static final String TWO = "00";
	private static final String ONE = "0";
	public static final int DEFAULT_MAX = 75;
	
	private static List<String> relationshipFamily = 
			ListUtil.toList( PortletProps.get(CaretStrPool.RELATIONSHIP_FAMILY).split(StringPool.COMMA));
	
	public static boolean isFamily(String individual) {
		return relationshipFamily.contains(individual);
	}

	public static class DateConverter implements Converter {
		@SuppressWarnings("rawtypes")
		public Object convert(Class type, Object value ){
			if ( value == null ){
				return null;
			}
			if ( value instanceof Date ){
				return value;
			} else {
				try {
					return parseDate( value.toString() );
				} catch ( Exception e ){
					_log.error("converter failed..." , e);
				}
			}
			return null;
		}
	}
	
	public static Format getDateFormat(){
		if ( dateFormat == null ){
			dateFormat = new DateFormatThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormat;
	}
	
	public static Format getDateFormatPdf(){
		if ( dateFormatPdf == null ){
			dateFormatPdf = new DateFormatPdfThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormatPdf;
	}
	
	public static Format getDateFormatOrient(){
		if ( dateFormatOrient == null ){
			dateFormatOrient = new DateFormatOrientThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormatOrient;
	}
	
	public static Format getDateFormatCprs(){
		if ( dateFormatCprs == null ){
			dateFormatCprs = new DateFormatCprsThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormatCprs;
	}

	public static Format getDateTimeFormatExpanded(){
		if ( dateTimeFormatExpanded == null ){
			dateTimeFormatExpanded = new DateTimeFormatExpandedThreadLocal<SimpleDateFormat>().get();
		}
		return dateTimeFormatExpanded;
	}

	public static Format getDateTimeFormat() {
		if ( dateTimeFormat == null ){
			dateTimeFormat  = new DateTimeFormatThreadLocal<SimpleDateFormat>().get();
		}
		return dateTimeFormat;
	}
	
	public static Format getDateMetadataFormat() {
		if ( dateMetadata == null ){
			dateMetadata  = new DateFormatMetadataThreadLocal<SimpleDateFormat>().get();
		}
		return dateMetadata;
	}

	public static String currencyFormat ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		if ( currencyInstance == null ){
			currencyInstance = new ThreadLocal<NumberFormat>().get();
		}
		return currencyInstance.format( value );
	}
	
	public static String formatDate ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateFormat().format( value );
	}
	
	public static String formatDatePdf ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateFormatPdf().format( value );
	}
	
	public static String formatDateOrient ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateFormatOrient().format( value );
	}
	
	public static String formatDateCprs ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateFormatCprs().format( value );
	}
	
	public static String formatDateTimeMetadata ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateMetadataFormat().format( value );
	}
	
	public static String formatDateTime ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateTimeFormat().format( value );
	}
	
	public static String formatZip ( Object value ){
		if ( value != null ) {
			int length = value.toString().length();
			if ( length > 4 ) return value.toString();
			
			switch(length){
				case 4: return ONE + value; 
				case 3: return TWO + value; 
				case 2: return THREE + value; 
				case 1: return FOUR + value; 
			}
		}
		return StringPool.BLANK;
	}
	
	public static String formatSsn ( String value ){
		if ( value != null && !value.isEmpty()) {
			if ( value.length() == 9 ) {
				return new StringBuilder(value).insert(5, '-').insert(3, '-').toString();
			}
			ApplicationWorkFlowException.handleException("Invalid PII data provided " + value.length() );
		}
		return StringPool.BLANK;
	}
	
	public static Date parseDate ( String dateStr ){
		if ( dateStr == null || CARET_DATE_FORMAT_UI.equals(dateStr) ) return null;
		try {
			return (Date) getDateFormat().parseObject( dateStr );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException("Invalid date format provided 1 " + dateStr);
		}
		return null;
	}
		
	public static Date parseMetadataTime ( String dateTimeStr ){
		if ( dateTimeStr == null ) return null;
		try {
			return (Date) getDateMetadataFormat().parseObject( dateTimeStr );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException("Invalid date format provided 2 " + dateTimeStr);
		}
		return null;
	}
	
	public static Date parseDateTime ( String dateTimeStr ){
		if ( dateTimeStr == null ) return null;
		try {
			return (Date) getDateTimeFormat().parseObject( dateTimeStr );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException("Invalid date format provided 3 " + dateTimeStr);
			return parseDate( dateTimeStr );
		}
//		return null;
	}
	
	public static Date parseOrientDate ( String dateStr ){
		if ( dateStr == null ) return null;
		try {
			return (Date) getDateFormatOrient().parseObject( dateStr );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException("Invalid date format provided 4 " + dateStr );
		}
		return null;
	}
	
	public static String getExpandoValue( ExpandoBridge expandoBridge,	String attributeName ) {
		return getExpandoValue(expandoBridge, attributeName, false);
	}
	
	public static String getExpandoValue( ExpandoBridge expandoBridge,
			String attributeName,
			Boolean isSecure ) {
		if ( Validator.isNotNull( attributeName ) && expandoBridge.hasAttribute( attributeName ) ) {
			return (String) expandoBridge.getAttribute( attributeName, isSecure );
		}
		return StringPool.BLANK;
	}
	
	public static boolean setExpandoValue( BaseModel<?> baseModel, String attributeName, String value ) {
		try {
			if ( Validator.isNotNull( attributeName ) ){
				if ( baseModel.getExpandoBridge().hasAttribute( attributeName ) ) {
					baseModel.getExpandoBridge().setAttribute( attributeName, value, false );
				} else {
					throw new ApplicationWorkFlowException(CaretStrPool.METADATA + " not initialized" );
				}
			}
			return true;
		}catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return false;
	}
			
	public static Note createNote(Date now, long chainId, long groupId, long userId,
			String messageString) {
		
		Note note;
		if ( messageString == null ){
			note = null;
			ApplicationWorkFlowException.handleException("CREATE NOTE on EMPTY ");
		} else {
			note = new NoteSupport ( new NoteImpl() );
			note.setCreationDate(now);
			note.setValue( messageString );
			note.setChainId(chainId);
			note.setGroupId(groupId);
			note.setUserId(userId);
		}
		return note;
	}
	
	public static List<WorIm> createWorkItems ( PortletRequest request, long groupId, BaseModel<?> src, boolean[] changes, long veteranPersnId, long caregiverPersnId ){
		List<WorIm> workItems = new ArrayList<WorIm>();
		Map<WorkType,WorIm> workItemMap = (Map)request.getAttribute("workItemMap");
		if ( workItemMap == null ){
			workItemMap = new HashMap<WorkType,WorIm>();
			request.setAttribute("workItemMap", workItemMap);
		}
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		WorIm workItem;
		for ( int ndx = 0; ndx < changes.length; ndx++ ){
			if ( changes[ndx] ){
				switch ( ndx ){
				case (0):
					if ( workItemMap.containsKey( WorkType.PII_CHANGE) ) continue;
				workItem = createWorkItem(sc, groupId, src, WorkType.PII_CHANGE, veteranPersnId, caregiverPersnId);
				workItemMap.put( WorkType.PII_CHANGE, workItem);
					workItems.add ( workItem );
					break;
				case (1):
					if ( workItemMap.containsKey( WorkType.NAME_CHANGE) ) continue;
				workItem = createWorkItem(sc, groupId, src, WorkType.NAME_CHANGE, veteranPersnId, caregiverPersnId);
				workItemMap.put( WorkType.NAME_CHANGE, workItem);
					workItems.add ( workItem );
					break;
				case (2):
					if ( workItemMap.containsKey( WorkType.INSURANCE_CHANGE) ) continue;
				workItem = createWorkItem(sc, groupId, src, WorkType.INSURANCE_CHANGE, veteranPersnId, caregiverPersnId);
				workItemMap.put( WorkType.INSURANCE_CHANGE, workItem);
					workItems.add ( workItem );
					break;
				case (3):
					if ( workItemMap.containsKey( WorkType.ADDRESS_CHANGE) ) continue;
				workItem = createWorkItem(sc, groupId, src, WorkType.ADDRESS_CHANGE, veteranPersnId, caregiverPersnId);
				workItemMap.put( WorkType.ADDRESS_CHANGE, workItem);
					workItems.add ( workItem );
					break;
				case (4):
					if ( workItemMap.containsKey( WorkType.FACILITY_CHANGE) ) continue;
				workItem = createWorkItem(sc, groupId, src, WorkType.FACILITY_CHANGE, veteranPersnId, caregiverPersnId);
				workItemMap.put( WorkType.FACILITY_CHANGE, workItem);
					workItems.add ( workItem );
					break;
				default:
				}
			}
		}
		return workItems;
	}
	
	public static WorIm createWorkItem ( ServiceContext sc, long groupId, BaseModel<?> src, WorkType type, long veteranPersnId, long caregiverPersnId ){
		return createWorkItem(sc, groupId, src, veteranPersnId,  type.name(), caregiverPersnId, type.getDueDate( sc.getCreateDate() ) );
	}
	
	public static WorIm createWorkItem ( ServiceContext sc, long groupId, BaseModel<?> src, long veteranPersnId, String name, long caregiverPersnId, Date dueDate ){
		return createWorkItem(sc, groupId, PortalUtil.getClassNameId( src.getModelClass() ), (Long)src.getPrimaryKeyObj(), veteranPersnId,  name, caregiverPersnId, dueDate );
	}
	
	public static WorIm createWorkItem ( ServiceContext sc, long groupId, long srcClassId, long srcPrimaryKey, long veteranPersnId, String name, long caregiverPersnId, Date dueDate ){
		WorIm workItem = new WorImImpl();
		workItem.setStatus( CaretStrPool.NEW );
		workItem.setCreationDate( sc.getCreateDate() );
		workItem.setGroupId( groupId );
		workItem.setClassPk( srcPrimaryKey );
		workItem.setPersnId(veteranPersnId);
		workItem.setCaregiverId(caregiverPersnId);
		workItem.setType( name );
		if ( _log.isInfoEnabled() ){
			_log.info("using DueDate=" + dueDate );
		}
		workItem.setDueDate( dueDate );
		if ( _log.isInfoEnabled() ){
			_log.info("using src.getModelClass()=" + srcClassId );
		}
		workItem.setClassId( srcClassId );
		return workItem;
	}

	public static WorIm createHomeVisitWorkItem ( ServiceContext sc, long groupId, BaseModel<?> src, WorkType type, long veteranPersnId, long caregiverPersnId, long vcgId, Date completionDate){
		WorIm workItem = new WorImImpl();
		workItem.setStatus( CaretStrPool.NEW );
		workItem.setCreationDate( sc.getCreateDate() );
		workItem.setGroupId( groupId );
		workItem.setType( type.name() );
		workItem.setClassPk( (Long)src.getPrimaryKeyObj() );
		workItem.setPersnId(veteranPersnId);
		workItem.setCaregiverId(caregiverPersnId);
		if ( _log.isInfoEnabled() ){
			_log.info("using DueDate=" + type.getBusinessDueDate( completionDate ) );
		}
		workItem.setDueDate( type.getBusinessDueDate( completionDate ) );
		if ( _log.isInfoEnabled() ){
			_log.info("using src.getModelClass()=" + src.getModelClass());
		}
		workItem.setClassId( PortalUtil.getClassNameId( src.getModelClass() ) );
		workItem.setVcgId(vcgId);
		return workItem;
	}

	
	public static Map<String,Map<String,Map<String,Long>>> getVhaOrgTree( long companyId, boolean includeNumber ) throws ApplicationWorkFlowException {
		
		if ( districtMap == null ){
			try {
				Organization head = OrganizationLocalServiceUtil.getOrganization( companyId, PortletProps.get(CaretStrPool.HEAD_ORG_NAME) );
				districtMap = new HashMap<String,Map<String,Map<String,Long>>>();
				for ( Organization district: OrganizationLocalServiceUtil.getOrganizations( companyId, head.getOrganizationId() ) ){
					Map<String,Map<String,Long>> visnMap = new TreeMap<String,Map<String,Long>>();
					districtMap.put(district.getName(), visnMap );
					for ( Organization visn: OrganizationLocalServiceUtil.getOrganizations( companyId, district.getOrganizationId() ) ){
						Map<String,Long> facilityMap = new TreeMap<String,Long>();
						visnMap.put(visn.getName(), facilityMap );
						for ( Organization facility : OrganizationLocalServiceUtil.getOrganizations( companyId, visn.getOrganizationId() ) ){
							Facil facil = FacilLocalServiceUtil.getByOrgId( facility.getPrimaryKey() );
							
							facilityMap.put( includeNumber? facil.getFacilityNumber() + StringPool.COMMA_AND_SPACE + facility.getName() + StringPool.COMMA_AND_SPACE + facil.getLocation() :
								facility.getName(),
									facility.getOrganizationId() );
						}
					}
				}
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException(e);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
			
		}
		return districtMap;
	}
	
	public static int getInteger ( Map<String,Object> map, String key ){
		return ( (java.math.BigDecimal) map.get(key) ).intValue();
	}
	
	public static long getLong ( Map<String,Object> map, String key ){
		return ( (java.math.BigDecimal) map.get(key) ).longValue();
	}
	
//	@SuppressWarnings({ "rawtypes" })
//	public static boolean isBoolean(BaseModel bean, String name) {
//		try {
//			return bean.getClass().getMethod( CaretStrPool.GET + StringUtil.upperCaseFirstLetter(name)).getReturnType() == boolean.class;
//		} catch (NoSuchMethodException e) {
//			ApplicationWorkFlowException.handleException(e);
//		} catch (SecurityException e) {
//			ApplicationWorkFlowException.handleException(e);
//		}
//		return false;
//	}

	public static Map<String, Object> getMap(Object... appId){
		Map<String, Object> map = new HashMap<String, Object>();
		for ( int i = 0; i < appId.length; i++ ){
			map.put( CaretStrPool.NDX +i, appId[i]);
		}
		return map;
	}
	
	public static Collection<String> getCollection(Object... appId){
		Collection<String> collection = new ArrayList<String>();
		for ( int i = 0; i < appId.length; i++ ){
			collection.add( appId[i].toString() );
		}
		return collection;
	}
	
	
	public static boolean isEmpty( String entry ) {
		return entry == null || entry.trim().length() == 0;
	}
	
	public static String nullSafe( Object entry ) {
		return entry == null? StringPool.BLANK : entry.toString();
	}
	
	@SuppressWarnings({ "rawtypes" })
	public static String chomp(Class c, BaseModel baseModel, String attribute,
			String value) {
		if ( modelConfig == null ){
			setModelConfig();
		}
		
		Class[] interfaces = c.getInterfaces();
		Class use = interfaces.length > 0? interfaces[0] : c;
		
		if ( value != null && modelConfig.containsKey( use ) ){
			Map<String,Integer> rules = modelConfig.get( use ) ;
			int rule = rules.get( attribute );
			return value.substring(0, Math.min( value.length(), rule ) );
		}
		
		return value.substring(0, Math.min( value.length(), DEFAULT_MAX ) );
	}

	@SuppressWarnings("rawtypes")
	private static void setModelConfig() {
		modelConfig = new HashMap<Class,Map<String,Integer>>();
		
		Map<String,Integer> configMap = new CaretMap<String,Integer>(75);
		configMap.put("comment", 400); 
		modelConfig.put( VcgAn.class, configMap );
		
		configMap = new CaretMap<String,Integer>(75);
		configMap.put("value", 400); 
		modelConfig.put( Note.class, configMap );
		
		configMap = new CaretMap<String,Integer>(75);
		configMap.put("cbopcNotes", 400);
		configMap.put("cscNotes", 400);
		modelConfig.put( Vcg.class, configMap );
		
		configMap = new CaretMap<String,Integer>(75);
		configMap.put("label", 255);
		modelConfig.put( BoxGp.class, configMap );

	}
	
	private static List<BoxGp> initBoxGroup( String name, String subName ) throws ApplicationWorkFlowException { 
		String boxGroupValues = PortletProps.get(subName);
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(name, subName);
		String[] labels =  boxGroupValues.split( StringPool.SEMICOLON );
		groups = new ArrayList<BoxGp>();
		int i = 0;
		for ( String label: labels ){
			BoxGp grp = new BoxGpImpl();
			grp.setBoxGroup(name);
			grp.setBoxSubGroup(subName);
			grp.setLabel(label);
			grp.setViewSequence(i++);
			try {
				groups.add( BoxGpLocalServiceUtil.addBoxGp(grp) );
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		return groups; 
	}

	public static List<BoxGp> loadBoxGroup ( String name, String subName ) throws ApplicationWorkFlowException {
		
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(name, subName);
		if ( groups.isEmpty() ){
			groups = Toolbox.initBoxGroup(name, subName);
		}
		return groups;
//		ResultMap.getForm(request).put( subName, groups );
	}
	
	public static void initYesNoBoxGp ( String subgroup, String yesNoGroup, List<BoxGp> list, int sequence ) throws ApplicationWorkFlowException{
		BoxGp yesAnswer = new BoxGpImpl();
		yesAnswer.setBoxGroup(yesNoGroup);
		yesAnswer.setBoxSubGroup(subgroup);
		yesAnswer.setLabel(CaretStrPool.YES);
		yesAnswer.setViewSequence(sequence);
		
		BoxGp noAnswer = new BoxGpImpl();
		noAnswer.setBoxGroup(yesNoGroup);
		noAnswer.setBoxSubGroup(subgroup);
		noAnswer.setLabel(CaretStrPool.NO);
		noAnswer.setViewSequence(sequence+1);
		try {
			list.add( BoxGpLocalServiceUtil.addBoxGp(yesAnswer) );
			list.add( BoxGpLocalServiceUtil.addBoxGp(noAnswer) );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}

	public static Date subtractFromNow ( double doubleValue ) {
		double flooredValue = Math.floor( doubleValue );
		double percentDay = doubleValue - flooredValue;
		
		Calendar calendar = Calendar.getInstance();
		if ( percentDay > 0 ){
			int minutesInt = Double.valueOf(percentDay * 24 * 60).intValue();
			if ( _log.isInfoEnabled() ){
				_log.info("subtracting minutes " + minutesInt );
			}
			calendar.add(Calendar.MINUTE, -minutesInt);
		}
		if ( percentDay >= 1){
			if ( _log.isInfoEnabled() ){
				_log.info("subtracting days for date..." + Double.valueOf(doubleValue).intValue() );
			}
			calendar.add(Calendar.DAY_OF_YEAR, -Double.valueOf(doubleValue).intValue() );
		}
		return calendar.getTime();
//		return adjustDate(doubleValue, new Date(), false);
	}
	
	public static Date adjustDate ( double doubleValue, Date date, boolean up ) {
		double days = Math.floor( doubleValue );
		double remainderPercentDay = doubleValue - days;
		
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		if ( remainderPercentDay > 0 ){
			int minutesInt = Double.valueOf(remainderPercentDay * 24 * 60).intValue();
			if ( _log.isInfoEnabled() ){
				_log.info( (up? " increasing ": "subtracting ") + "minutes by " + minutesInt );
			}
			calendar.add(Calendar.MINUTE, up? minutesInt : -minutesInt);
		}
		if ( days >= 1){
			if ( _log.isInfoEnabled() ){
				_log.info( (up?"increasing ": "subtracting ") + "days by " + days );
			}
			calendar.add(Calendar.DAY_OF_YEAR, up? (int)days: (int)-days );
		}
		if ( _log.isDebugEnabled() ){
			_log.debug( "now.compareTo(rollDate): " + new Date().compareTo( calendar.getTime() ) );
		}
		return calendar.getTime();
	}
	
	
	public static Date adjustBusinessDate( double days, Date startDate, boolean up ) 
	{		
	    Calendar calendar = Calendar.getInstance();
	    calendar.setTime(startDate);
    
	    for(int i=0;i<=days;)
	    {
			calendar.add(Calendar.DAY_OF_YEAR, up? 1: -1 );

	        if(!BusinessDayUtil.isWeekend(calendar) && !BusinessDayUtil.isHoliday(calendar))
	        {
	            i++;
	        }
	    }  
	    if ( _log.isDebugEnabled() ){
	    	_log.debug("due date is : "+Toolbox.getDateFormatCprs().format(calendar.getTime()));
	    }
		return calendar.getTime();
	}

	public static boolean isValidateUspsAddress ( String userAddress, String userCity, String userState, String userZip ){
	    String urlQuery = "API=Verify&XML=<AddressValidateRequest USERID=\"402VA0000550\"><IncludeOptionalElements>true</IncludeOptionalElements><ReturnCarrierRoute>true</ReturnCarrierRoute><Address ID=\"0\"><FirmName /><Address1 /><Address2>"+userAddress+"</Address2><City>"+userCity+"</City><State>"+userState+"</State><Zip5>"+userZip+"</Zip5><Zip4></Zip4></Address></AddressValidateRequest>";
	    try{
	        URI uri = new URI(
	                        "http", 
	                        "production.shippingapis.com", 
	                        "/ShippingAPI.dll",
	                        urlQuery,
	                        null);
	        URL url = uri.toURL();
	        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	        DocumentBuilder db = factory.newDocumentBuilder();
	        Document doc = db.parse(url.openStream());
	        doc.getDocumentElement().normalize();
	        NodeList nodeList = doc.getElementsByTagName("Error");
	        if (nodeList != null && nodeList.getLength() > 0) {
	            return false;
	        }
	        return true;
	    } catch (Exception e) {
	        ApplicationWorkFlowException.handleException(e);
	    }
	    return false;
	}
	
	@SuppressWarnings("rawtypes")
	private static Map<Class,Map<String,Integer>> modelConfig = null;
	private static Log _log = LogFactoryUtil.getLog( Toolbox.class );
	
	public static boolean toBoolYesNo(String label) {
		return CaretStrPool.YES.equals(label);
	}

	public static Collection<String> getAddressCollection() {
		return Toolbox.getCollection("city","state","zip","validAddress");
	}
	
	public static String getPersnFullName(long persnId) {
		try { 
			Persn persn = PersnLocalServiceUtil.getPersn( persnId );
			if ( CaretStrPool.UNKNOWN_IDENTITY.equals( persn.getStatus() ) ){
				return CaretStrPool.UNKNOWN_IDENTITY;
			} else {
				return persn.getLastName() + StringPool.COMMA_AND_SPACE + persn.getFirstName();
			}
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return StringPool.BLANK;
	}
	
	public static String getUserFullName(long userId) {
		try { 
			User user = UserLocalServiceUtil.getUser( userId );
			return user.getLastName() + StringPool.COMMA_AND_SPACE + user.getFirstName();
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return StringPool.BLANK;
	}

	public static boolean isMviEnabled() {
		return StringPool.TRUE.equals( PropsUtil.get( "search.mvi.attended.enabled" ) );
	}

	public static String parsePhone(String phone) {
		if ( Person.PHONE_FORMAT.equals( phone ) ){
			return StringPool.BLANK;
		}
		return phone;
	}
	
	public static String parseEmail(String email) {
		if ( Person.EMAIL_FORMAT.equals( email ) ){
			return StringPool.BLANK;
		}
		return email;
	}

	public static Map<Long, String> getVhaOrgList(PortletRequest actionRequest) throws ApplicationWorkFlowException {
		Map<Long, String> linked = new LinkedHashMap<Long, String>();
		FacilityDashboardConfig config = (FacilityDashboardConfig)actionRequest.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG);
		try {
			Organization org = OrganizationLocalServiceUtil.getOrganization( config.getGroupId() );
			Facil facil = FacilLocalServiceUtil.getByOrgId( org.getOrganizationId() );
			if ( facil == null ){
				// linked.put( 1l, org.getName() );
				for ( Organization subOrg : org.getSuborganizations()){
					linked.put( subOrg.getOrganizationId(), subOrg.getName() );
				}
			} else {
				linked.put( facil.getGroupId(), facil.getFacilityNumber() + StringPool.COMMA_AND_SPACE + org.getName() + StringPool.COMMA_AND_SPACE + facil.getLocation() );
			}
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		return linked;
	}

}
